using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Web;
using System.Web.Services;
using System.Xml;
using System.IO;
using System.Text;
using System.Runtime.Remoting;

namespace Team_Project.Web
{
	[WebService(Namespace="TeamProject.ProgettiUniversita.Bertaccini")]
	public class WebInterface : System.Web.Services.WebService
	{
		public WebInterface()
		{
			//CODEGEN: This call is required by the ASP.NET Web Services Designer
			InitializeComponent();
		}

		#region Component Designer generated code
		
		//Required by the Web Services Designer 
		private IContainer components = null;
				
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if(disposing && components != null)
			{
				components.Dispose();
			}
			base.Dispose(disposing);		
		}
		
		#endregion

		[WebMethod]
		public string PerformAction(string action)
		{
			try
			{
				string connection = System.Configuration.ConfigurationSettings.AppSettings["GlobalsUrl"];
				Globals gl = (Globals)RemotingServices.Connect(typeof(Globals),connection);
				MsgElabChainManager ecm = (MsgElabChainManager)gl.Data["ChainManager"];
				IOperationHandler oh = ecm.GetRoot();
				Hashtable ht = new Hashtable();
			
				bool ok;
				return oh.Compute(ht,action,out ok);
			}
			catch(Exception e )
			{
				return "<TeamProjectResponse><Error>" + e.Message +
					"</Error></TeamProjectResponse>";
			}
		}

		[WebMethod]
		public void AccessTPTree()
		{
			Team_Project.PersistencyManagers.CopiesTreeManager ctm = 
				(Team_Project.PersistencyManagers.CopiesTreeManager)Globals.Instance.Data["TreeManager"];
			ctm.AccessTeamProjectTree();
		}
	}
}
